/*Simple Custom Slider (Pure JS) by RJA 2025 JS Widgets Series*/

//slider settings & initialization
var slider = document.querySelectorAll(".slider");
var slides = document.querySelectorAll(".slides");
var slides_item = document.querySelectorAll(".slides li");
var arrows = document.querySelectorAll(".arrows");
var arrows_pn = document.querySelectorAll(".arrows span");
var buttons_wrapper = document.querySelectorAll(".buttons");
var buttons = "";
var indicators = [];
var startSlide = [];
var timer = [];
var slideInterval = [];
var gcs = window.getComputedStyle(slides_item[0]);
var sec = gcs.getPropertyValue("animation-duration");
var loader = document.querySelectorAll(".loader");



//get slide-start values
for(var ss = 0; ss < slider.length; ss++){
	var ss_val = slider[ss].getAttribute("start-slide");
	if(ss_val != null){
	    ss_val = ss_val.trim();
	}
	
	if(ss_val === null || ss_val === undefined || ss_val === "" || ss_val > slider.length || ss_val < 0 || isNaN(ss_val)){
		ss_val = 0;
	}
	
	startSlide.push(parseInt(ss_val,10));
}

//get slide-type values: carousel
for(var st = 0; st < slider.length; st++){
	var st_val = slider[st].getAttribute("type");
	if(st_val){
		slider[st].children[0].classList.add("carousel");
	}
}
 
 //setting orders, ids, attributes, visibility, active elements
for(var n = 0; n < slides.length; n++){
slider[n].setAttribute("order",n);
buttons_wrapper[n].setAttribute("id",n);
slides[n].setAttribute("id",n);
arrows[n].setAttribute("id",n);

var getType = slider[n].getAttribute("type");
var getAnimate = slider[n].getAttribute("animate");
var getOverlap = slider[n].getAttribute("overlap");
var getMode = slider[n].getAttribute("mode");
var getWidth = slider[n].getAttribute("width");
var getNumber = slider[n].getAttribute("number");
var bwc_length = buttons_wrapper[n].children.length;
var bwc_elem = buttons_wrapper[n].children;
var sc_length = slides[n].children.length;
var sc_elem = slides[n].children;
var slides_index = startSlide[n];

if(getType == "carousel"){ //forced buttons off and remove start-slide attribute for slider type: carousel
	slider[n].setAttribute("buttons","off");
	slider[n].removeAttribute("start-slide");
	
	if(getAnimate == null || getAnimate == "moveUp" || getAnimate == "moveDown" || getAnimate == "fadingIn" || getAnimate == "fadingOut"){		
		getAnimate = "moveRight";
		slider[n].setAttribute("animate", getAnimate);
	}	
}

if(getOverlap == "yes"){
	slides[n].classList.add("overlap");	
}

if(getWidth == "threeFourth" || getWidth == "oneHalf" || getWidth == "oneFourth" || getWidth == "oneThird"){
	slider[n].classList.add(getWidth);
}

if(getMode == "facebook"){
	slides[n].classList.add(getMode);
	//slides[n].classList.add("start");
	
	if(getAnimate == "moveRight"){
		/*slides[n].classList.add("end");*/
		arrows[n].children[0].setAttribute("class","hidden");
	}	
	
	if(getAnimate == "moveLeft"){
		slides[n].classList.add("start");
		arrows[n].children[0].setAttribute("class","hidden");
	}
	
	if(window.innerWidth <= 980){ //changes this to on window resize event OR use an observer
		var number = 0;
		if(getOverlap == "yes"){
			slider[n].removeAttribute("overlap");			
			slides[n].classList.remove("overlap");			
			slides[n].classList.remove("start");

			if(sc_elem.length > 5){
				number = 2;
			}

			if(sc_elem.length <= 5){
				number = 3;
			}						
		}

		if(getOverlap != "yes"){
			var number = 0;
			if(sc_elem.length > 5){
				number = 2;
			}

			if(sc_elem.length <= 5){
				number = 3;
			}						
		}
		
		slider[n].setAttribute("number",number);
			
		for(var nu = 0; nu < sc_elem.length; nu++){
			if(nu >= slider[n].getAttribute("number")){
				sc_elem[nu].setAttribute("class","hidden");
			}
		}

	}	
	
	if(getOverlap != "yes"){
		if(getNumber == null){
			if(sc_elem.length > 5){
				getNumber = 3;
				slider[n].setAttribute("number",getNumber);
			}
			
			if(sc_elem.length < 5){
				getNumber = 2;
				slider[n].setAttribute("number",getNumber);			
			}
		}		
		for(var num = 0; num < sc_elem.length; num++){
			if(num >= getNumber){
				sc_elem[num].setAttribute("class","hidden");
			}
		}
	}

	
}

if(getMode == "common"){
	if(window.innerWidth <= 980){ //changes this to on window resize event OR use an observer
		if(getOverlap == "yes"){
			slider[n].removeAttribute("overlap");			
			slides[n].classList.remove("overlap");	
		}
	}
}

if(getType != "carousel"){
	slider[n].removeAttribute("mode");
	slider[n].removeAttribute("overlap");
}

//add indicators to buttons control
for(var sc = 0; sc < sc_elem.length; sc++){
	indicators[sc] = document.createElement("span");
	buttons_wrapper[n].append(indicators[sc]);
}

buttons = document.querySelectorAll(".buttons span");

//initialize visible slide, visible buttons control, active button
for(var vs = 0; vs < sc_length; vs++){
	sc_elem[vs].setAttribute("order",vs); //set order to slides children
	bwc_elem[vs].setAttribute("order",vs); //set order to buttons children
}

if(getType == null || getType != "carousel"){
	sc_elem[slides_index].setAttribute("class","visible"); //visible slide	
	bwc_elem[slides_index].setAttribute("class","active"); //active buttons
	buttons_wrapper[n].classList.add("visible");  //visible button control
}

//slider mouse over/out event
slider[n].addEventListener(//over
"mouseover", function(e){
	var id = this.getAttribute("order");
	if(id){
		//setAnimate_effect(id,"");
		mouse_over_out("mouseover",id);
	}

}
);

slider[n].addEventListener(//out
"mouseout", function(e){
	var id = this.getAttribute("order");
	if(id){
		//setAnimate_effect(id,sec);
		mouse_over_out("mouseout",id);
	}

}
);

//adding keypress feature: arrows right & left
ArrowsKeypress(n);
}

//arrows previous next click event
for(var i = 0; i < arrows_pn.length; i++){
arrows_pn[i].setAttribute("arrow-num",i);

 arrows_pn[i].addEventListener(
 "click", function(e){
 //e.preventDefault(); e.stopPropagation();
	var id = e.target.parentNode.id;
	var arrow_num = this.getAttribute("arrow-num");

	if(arrow_num % 2 === 0){
		pn_slide("Prev",id);
		return;
	} 
		pn_slide("Next",id);
	}
 );
}

//previous next event function handler
function pn_slide(pn,id){
var slides_elem = slides[id].children;
var btns_elem = buttons_wrapper[id].children;
var getType = slider[id].getAttribute("type");
var getAnimate = slider[id].getAttribute("animate");
var getMode = slider[id].getAttribute("mode");
var getOverlap = slider[id].getAttribute("overlap");
var getWidth = slider[id].getAttribute("width");
var getNumber = slider[id].getAttribute("number");
var delay = 500;
var seLen = 0;
var reset = 0;
//console.log(id);

if(getOverlap != "yes"){
	seLen = slides_elem.length - getNumber;
	reset = slides_elem.length - getNumber + 1;
}

if(getOverlap == "yes"){
	seLen = slides_elem.length - 3;
	reset = slides_elem.length - 2;
}

if(pn === "Prev"){	
	if(getType == null || getType != "carousel"){	
		for(var i = 0; i < slides_elem.length; i++){
			var currentSlide = slides_elem[i].getAttribute("class");
			//var currentOrder = slides_elem[i].getAttribute("order");
			var lastSlide = slides_elem.length - 1;
			var order = slides_elem[i].getAttribute("order");
			
			setAnimate_effect(id,sec,"Prev");
			
			if(currentSlide){
				setTimeout(function(e){
					for(var i = 0; i < slides_elem.length; i++){
						slides_elem[i].removeAttribute("class");
						btns_elem[i].removeAttribute("class");
					}
				},delay);
				
				if(order == 0){
					setTimeout(function(e){
						slides_elem[lastSlide].removeAttribute("style");	
						slides_elem[lastSlide].setAttribute("class","visible");
						btns_elem[lastSlide].setAttribute("class","active");
					},delay);

					return;
				}
				
				if(order !=0){
					if(order < lastSlide){
						setTimeout(function(e){
							order--;
							slides_elem[order].removeAttribute("style");
							slides_elem[order].setAttribute("class","visible");
							btns_elem[order].setAttribute("class","active");
						},delay);
						
						return;
					}
					
					if(order == lastSlide){
						setTimeout(function(e){
							order--;	
							slides_elem[order].removeAttribute("style");
							slides_elem[order].setAttribute("class","visible");
							btns_elem[order].setAttribute("class","active");
						},delay);
					}
				}
			}
			
		}
	}
	
	if(getType === "carousel"){
		if(getAnimate == "moveLeft"){
			getAnimate = "moveRight";
		}

		//version 1
		if(getMode == "custom" || getMode == null){
			slides[id].lastElementChild.setAttribute("style","--animate: " + getAnimate + " " + sec);
			
			setTimeout(function(e){
				slides[id].prepend(slides[id].lastElementChild);
				slides[id].firstElementChild.setAttribute("style","--animate: none; margin-left: 20%;");	
				slides[id].firstElementChild.removeAttribute("style");
			}, 500);
		}
		
		//version 2
		if(getMode == "common"){
			carouselModeEffect(getAnimate,slides_elem,"setStyle");
			setTimeout(function(e){
				carouselModeEffect(getAnimate,slides_elem,"removeStyle");	
				slides[id].prepend(slides[id].lastElementChild);
				slides[id].firstElementChild.setAttribute("style","--animate: none;");
			}, 100);
		}
		
		//version 3
		if(getMode == "facebook"){
			if(getOverlap == "yes"){			
				slides[id].firstElementChild.setAttribute("style","--animate: none;");				
			}	
					
			carouselModeEffect(getAnimate,slides_elem,"setStyle");		

			setTimeout(function(e){				
				carouselModeEffect(getAnimate,slides_elem,"removeStyle");
				slides[id].prepend(slides[id].lastElementChild);
				slides[id].firstElementChild.setAttribute("style","--animate: none;");
				
				var getSlastC = slides[id].lastElementChild.getAttribute("order");					
				
				if(getSlastC != slides_elem.length - 1){
					arrows[id].children[1].removeAttribute("class");
				
					if(getOverlap == "yes"){
						/*for(var s = 0; s < slides_elem.length; s++){
							slides_elem[s].setAttribute("style","--animate: none;");
						}*/
						if(!getSlastC){
							slides[id].firstElementChild.setAttribute("style","--animate: none; margin-left: -28%;");
						}
					}
					
					
					if(getOverlap != "yes"){
						slides[id].firstElementChild.removeAttribute("class");
						slides_elem[getNumber].setAttribute("class","hidden");
					}
				}
								
				if(getSlastC == slides_elem.length - 1){
					arrows[id].children[0].setAttribute("class","hidden");
					slides[id].firstElementChild.removeAttribute("class");
					
					/*for(var ls = 0; ls < slides_elem.length; ls++){
						slides_elem[ls].setAttribute("style","--animate: none;");
					}*/

					//slides_elem[getSlastC].setAttribute("style","--animate: none;");

					if(getOverlap != "yes"){
						slides_elem[getNumber].setAttribute("class","hidden")
					}
					
				}			
			},100);
		}	
		
	}		
 }

if(pn === "Next"){
	if(getType == null || getType != "carousel"){	
		for(var i = 0; i < slides_elem.length; i++){
			var currentSlide = slides_elem[i].getAttribute("class");
			//var currentOrder = slides_elem[i].getAttribute("order");
			var lastSlide = slides_elem.length - 1;
			var order = slides_elem[i].getAttribute("order");
			
			setAnimate_effect(id,sec,"Next");
				
			if(currentSlide){
				setTimeout(function(e){
					for(var i = 0; i < slides_elem.length; i++){
						slides_elem[i].removeAttribute("class");
						btns_elem[i].removeAttribute("class");
					}
				},delay);

				if(order == 0){
					setTimeout(function(e){
						order++;
						slides_elem[order].removeAttribute("style");
						slides_elem[order].setAttribute("class","visible");
						btns_elem[order].setAttribute("class","active");
					},delay);

					return;
				}
				if(order != 0){
					if(order >= 1 && order != lastSlide){	
						setTimeout(function(e){
							order++;
							slides_elem[order].removeAttribute("style");
							slides_elem[order].setAttribute("class","visible");
							btns_elem[order].setAttribute("class","active");
						},delay);

						return;
					}
					if(order == lastSlide){
						setTimeout(function(e){
							slides_elem[0].removeAttribute("style");
							slides_elem[0].setAttribute("class","visible");
							btns_elem[0].setAttribute("class","active");
						},delay);						
					}
					
				}
			
			}
		}
	}
	
	if(getType === "carousel"){
		if(getAnimate == "moveRight"){
			getAnimate = "moveLeft";
		}	
	
		//version 1
		if(getMode == "custom" || getMode == null){
			slides[id].firstElementChild.setAttribute("style","--animate: " + getAnimate + " " + sec);
			
			setTimeout(function(e){
				slides[id].append(slides[id].firstElementChild);
				slides[id].lastElementChild.setAttribute("style","--animate: none; margin-right: 20%;");	
				slides[id].lastElementChild.removeAttribute("style");
			}, 500);
		}

		//version 2
		if(getMode == "common"){
			carouselModeEffect(getAnimate,slides_elem,"setStyle");
			
			setTimeout(function(e){
				carouselModeEffect(getAnimate,slides_elem,"removeStyle");		
				slides[id].append(slides[id].firstElementChild);
				slides[id].lastElementChild.setAttribute("style","--animate: none;");
			}, 100);
		}
		//version 3
		if(getMode == "facebook"){
			carouselModeEffect(getAnimate,slides_elem,"setStyle");
			
			setTimeout(function(e){
				carouselModeEffect(getAnimate,slides_elem,"removeStyle");
				slides[id].append(slides[id].firstElementChild);
				slides[id].lastElementChild.setAttribute("style","--animate: none;");
				
				var getSfirstC = slides[id].firstElementChild.getAttribute("order");
				
				if(getSfirstC != 0 || getSfirstC != slides_elem.length - 1){//not first nor last
					arrows[id].children[0].removeAttribute("class");

					if(getOverlap == "yes"){
						slides[id].firstElementChild.setAttribute("style","--animate: none; margin-left: -28%;");
					}					

					if(getOverlap != "yes"){
						slides_elem[getNumber-1].setAttribute("style","--animate: none;");
						slides_elem[getNumber-1].removeAttribute("class");
						slides[id].lastElementChild.setAttribute("class","hidden");
						arrows[id].children[1].removeAttribute("class");
					}					
				}
				
				if(getSfirstC == 0){//first
					arrows[id].children[1].removeAttribute("class");
					arrows[id].children[0].setAttribute("class","hidden");				
				}
				
				if(getSfirstC == seLen){//last
					arrows[id].children[1].setAttribute("class","hidden");
					
					if(getOverlap == "yes"){
						slides[id].firstElementChild.setAttribute("style","--animate: none; margin-left: -17%;");
					}					
				}
				
				if(getSfirstC == reset){//reset					
					if(getOverlap == "yes"){
						arrows[id].children[0].setAttribute("class","hidden");
						arrows[id].children[1].removeAttribute("class");
						slides[id].firstElementChild.setAttribute("style","--animate: none;");
						for(var ap = 0; ap < slides_elem.length - reset; ap++){
							slides[id].append(slides[id].firstElementChild);
						}
					}

					if(getOverlap != "yes"){		
						arrows[id].children[0].setAttribute("class","hidden");
						for(var sl = 0; sl < slides_elem.length; sl++){
							var getClass = slides_elem[sl].getAttribute("class"); //get hidden class
							
							if(getClass != null){	
								slides_elem[sl].removeAttribute("class"); //remove hidden class								
							}
							
							//console.log(slides_elem[sl]);								
						}
						
						var count = slides_elem.length - reset;
						
						while(count > 0){
							slides[id].append(slides[id].firstElementChild); //append to reset
							count--;
						}
						
						for(var h = 0; h < slides_elem.length; h++){
							if(h >= getNumber){
								slides_elem[h].setAttribute("class","hidden"); //add hidden class to carousel based on numbers to hide or show
							}
						}
					}
				}
				
			}, 100);		
		}			

	}	
} 
}

//set animation effect function handler
function setAnimate_effect(index,secs,ctrl=""){
	var a = slider[index].getAttribute("animate");
	var getType = slider[index].getAttribute("type");
	
	if(a != null){
		var id = slides[index].parentNode.getAttribute("order");
		var slc_elem = slides[id].children;
		var bc_elem = buttons_wrapper[id].children;
	
		for(var d = 0; d < slc_elem.length; d++){
			if(ctrl == "Prev"){
				if(a == "moveDown"){
					a = "moveUp";
				}
				
				if(a == "moveRight"){
					a = "moveLeft";
				}
				
			}
			if(ctrl == "Next"){
				if(a == "moveUp"){
					a = "moveDown";
				}
			
				if(a == "moveLeft"){
					a = "moveRight";
				}

			}

			if(slc_elem[d].getAttribute("class")){
				if(getType != "carousel"){
					slc_elem[d].setAttribute("style","--animate: " + a + " " + sec);
				}
			} else{
				if(getType == null || getType != "carousel"){
					//slc_elem[d].setAttribute("style","--animate: " + a + " " + sec);
					slc_elem[d].removeAttribute("style");
				}
			}
		}
	}
	
	if(a == null){
		slider[index].setAttribute("animate", "fadingIn"); //set to default
	}
}

//get timer speed
for(var sp = 0; sp < slider.length; sp++){
	var speed = slider[sp].getAttribute("speed");
	if(speed == null || speed == undefined){speed = 3000;}
	timer.push(parseInt(speed,10));	
	slideInterval.push(sp);
}

//passing loop variable index to setInterval - slides...credit to soc
for (var t = 0; t < slider.length; t++) {
    (function(t) {
        slideInterval[t] = setInterval(function() {	
			if(slider[t].getAttribute("autoplay") == "" || slider[t].getAttribute("autoplay") == "on"){			
				slide(t); //autoplay
				loop(t,timer[t]); //loop
				setAnimate_effect(t,sec); //animation effect
			}
			if(slider[t].getAttribute("autoplay") == undefined || slider[t].getAttribute("autoplay") == "off"){
				slider[t].setAttribute("autoplay", "off");
			}
        }, timer[t])
    })(t);
} 

//loop function handler
function loop(id,delay){
	var l = slider[id].getAttribute("loop");
	var slides_elem = slides[id].children;
	var loop = l * slides_elem.length;
	//console.log(id+"=>"+loop);

	var looper = function(){//looper
           if(loop-- > 0){
              setInterval(looper, delay);
           }
		   	if(loop === 0){
				slider[id].removeAttribute("loop");
				slider[id].removeAttribute("autoplay");
				clearInterval(slideInterval[id]);
			}
        }
        looper();
}
 
 //buttons click event
 for(var ib = 0; ib < buttons.length; ib++){
	buttons[ib].addEventListener(
	"click", function(e){
		var order = parseInt(this.getAttribute("order"),10); //get the order number, current/active button
		var id = e.target.parentNode.id;
		var btns_length = buttons_wrapper[id].children.length;
		var btns_elem = buttons_wrapper[id].children;
		var slides_elem = slides[id].children;
		var delay = 500;
		
		setAnimate_effect(id,sec);	//buttons control click animate
		
		for(var i = 0; i < btns_length; i++){
			if(btns_elem[i].getAttribute("class")){//get active button
				var prev_order = btns_elem[i].getAttribute("order"); //get previous button
				var a = slider[id].getAttribute("animate");				
				//buttons control indicator logic: move left/right & up/down
					
				slides_elem[order].removeAttribute("style");

				if(order > prev_order){
					//console.log("move right/down");
					if(a == "moveUp"){
						a = "moveDown";						
					}
					if(a == "moveLeft"){
						a = "moveRight";						
					}

					slides_elem[prev_order].setAttribute("style", "--animate: " + a + " " + sec);					
															
					setTimeout(function(e){
						for(var i = 0; i < btns_length; i++){
							btns_elem[i].removeAttribute("class");
							slides_elem[i].removeAttribute("class");
						}
					},delay);
					
					setTimeout(function(e){
						slides_elem[order].setAttribute("class","visible");
						btns_elem[order].setAttribute("class","active");
					},delay);
					
				}
				if(order < prev_order){	
					//console.log("move left/up");
					if(a == "moveDown"){
						a = "moveUp";
					}
					if(a == "moveRight"){
						a = "moveLeft";						
					}

					slides_elem[prev_order].setAttribute("style", "--animate: " + a + " " + sec);					
										
					setTimeout(function(e){
						for(var i = 0; i < btns_length; i++){
							btns_elem[i].removeAttribute("class");
							slides_elem[i].removeAttribute("class");
						}
					},delay);
					
					setTimeout(function(e){
						slides_elem[order].setAttribute("class","visible");
						btns_elem[order].setAttribute("class","active");
					},delay);					
				}
				
			}
			
		}
	
	
	}
	);
 }
 
 //controllers
 for(var bc = 0; bc < buttons_wrapper.length; bc++){//buttons control
	var buttons_control = slider[bc].getAttribute("buttons");
	if(buttons_control=="off"){
		var s = slider[bc].getAttribute("order");
		buttons_wrapper[s].classList.remove("visible");
	}
 }
 
 for(var ac = 0; ac < arrows.length; ac++){//arrows control
	var arrows_control = slider[ac].getAttribute("arrows");
	if(arrows_control=="off"){
		var s = slider[ac].getAttribute("order");
		arrows[s].classList.remove("visible");
	}
 }

 //slider mouse over/out events function handler 
 function mouse_over_out(event,arr){
	if(event === "mouseover"){	
	    for(var a = 0; a < arrows.length; a++){	
				if(slider[arr].getAttribute("arrows")!="off"){
					arrows[arr].classList.add("visible");
				}
				if(slider[arr].getAttribute("hover-pause") == "on" || slider[arr].getAttribute("hover-pause") == ""){
					if(slider[arr].getAttribute("autoplay") == "on" || slider[arr].getAttribute("autoplay") == ""){
						slider[arr].setAttribute("autoplay","pause");
					}
				}
		}
		
		slider[arr].setAttribute("key","active");
	}
	
	if(event === "mouseout"){		
		for(var a = 0; a < arrows.length; a++){
			if(slider[arr].getAttribute("arrows")!="off"){
				arrows[arr].classList.remove("visible");
			}
			if(slider[arr].getAttribute("hover-pause") == "on" || slider[arr].getAttribute("hover-pause") == ""){
				if(slider[arr].getAttribute("autoplay") == "pause"){
					slider[arr].setAttribute("autoplay","on");
				}
			}			
		}
		
		slider[arr].removeAttribute("key");
	}
 }
 
//slide function handler
 function slide(i){
 	var slides_elem = slides[i].children;	
	var btns_elem = buttons_wrapper[i].children;
	var delay = 1000;
	var getType = slider[i].getAttribute("type");
	var getMode = slider[i].getAttribute("mode");
	var getAnimate = slider[i].getAttribute("animate");
	var getOverlap = slider[i].getAttribute("overlap");
	var getWidth = slider[i].getAttribute("width");
	var getNumber = slider[i].getAttribute("number");
	var seLen = 0;
	var reset = 0;
		
	if(getType == null || getType != "carousel"){
		for(var s = 0; s < slides_elem.length; s++){ //same conditions with arrow Next
			var order = slides_elem[s].getAttribute("order");
			var currentOrder = slides_elem[s].getAttribute("order");
			var currentSlide = slides_elem[s].getAttribute("class");
			var lastSlide = slides_elem.length - 1;
				
			if(currentSlide){
				setTimeout(function(e){
					for(var i = 0; i < slides_elem.length; i++){
						slides_elem[i].removeAttribute("class");
						btns_elem[i].removeAttribute("class");
					}
				},delay);

				if(order == 0){
					setTimeout(function(e){
						order++;
						slides_elem[order].removeAttribute("style");
						slides_elem[order].setAttribute("class","visible");
						btns_elem[order].setAttribute("class","active");
					},delay);

					return;
				}
				if(order != 0){
					if(order >= 1 && order != lastSlide){	
						setTimeout(function(e){
							order++;
							slides_elem[order].removeAttribute("style");
							slides_elem[order].setAttribute("class","visible");
							btns_elem[order].setAttribute("class","active");
						},delay);

						return;
					}
					if(order == lastSlide){
						setTimeout(function(e){
							slides_elem[0].removeAttribute("style");
							slides_elem[0].setAttribute("class","visible");
							btns_elem[0].setAttribute("class","active");
						},delay);						
					}
					
				}
			
			}

		}
	}
	
	if(getType == "carousel"){
		//version 1
		if(getMode == "custom" || getMode == null){
			if(getAnimate == "moveRight"){
				getAnimate = "moveLeft";
			}	
				slides[i].firstElementChild.setAttribute("style","--animate: " + getAnimate + " " + sec);
				
				setTimeout(function(e){
					slides[i].append(slides[i].firstElementChild);
					slides[i].lastElementChild.setAttribute("style","--animate: none; margin-right: 20%");	
					slides[i].lastElementChild.removeAttribute("style");
				},delay-500);			
		}
		
		//version 2
		if(getMode == "common"){			
			carouselModeEffect(getAnimate,slides_elem,"setStyle");
		
			setTimeout(function(e){
				carouselModeEffect(getAnimate,slides_elem,"removeStyle");
				slides[i].append(slides[i].firstElementChild);
				slides[i].lastElementChild.setAttribute("style","--animate: none;");				
			}, 100);
		}

		//version 3
		if(getMode == "facebook"){
			if(getOverlap != "yes"){
				seLen = slides_elem.length - getNumber;
				reset = slides_elem.length - getNumber + 1;
			}
			
			if(getOverlap == "yes"){
				seLen = slides_elem.length - 3;
				reset = slides_elem.length - 2;
			}		
		
			carouselModeEffect(getAnimate,slides_elem,"setStyle");
			
			setTimeout(function(e){
				carouselModeEffect(getAnimate,slides_elem,"removeStyle");
				slides[i].append(slides[i].firstElementChild);
				slides[i].lastElementChild.setAttribute("style","--animate: none;");
				
				var getSfirstC = slides[i].firstElementChild.getAttribute("order");
				
				if(getSfirstC != 0 || getSfirstC != slides_elem.length - 1){//not first nor last
					arrows[i].children[0].removeAttribute("class");	
					
					if(getOverlap == "yes"){
						slides[i].firstElementChild.setAttribute("style","--animate: none; margin-left: -28%;");
					}

					if(getOverlap != "yes"){
						slides_elem[getNumber-1].setAttribute("style","--animate: none;");
						slides_elem[getNumber-1].removeAttribute("class");
						slides[i].lastElementChild.setAttribute("class","hidden");
						arrows[i].children[1].removeAttribute("class");
					}					
				}
				
				if(getSfirstC == 0){//first
					arrows[i].children[1].removeAttribute("class");
					arrows[i].children[0].setAttribute("class","hidden");				
				}
				
				if(getSfirstC == seLen){//last
					arrows[i].children[1].setAttribute("class","hidden");
					
					if(getOverlap == "yes"){
						slides[i].firstElementChild.setAttribute("style","--animate: none; margin-left: -17%;");
					}					
				}
				
				if(getSfirstC == reset){//reset					
					if(getOverlap == "yes"){
						arrows[i].children[0].setAttribute("class","hidden");
						arrows[i].children[1].removeAttribute("class");
						slides[i].firstElementChild.setAttribute("style","--animate: none;");
						for(var ap = 0; ap < slides_elem.length - reset; ap++){
							slides[i].append(slides[i].firstElementChild);
						}
					}

					if(getOverlap != "yes"){		
						arrows[i].children[0].setAttribute("class","hidden");
						for(var sl = 0; sl < slides_elem.length; sl++){
							var getClass = slides_elem[sl].getAttribute("class"); //get hidden class
							
							if(getClass != null){	
								slides_elem[sl].removeAttribute("class"); //remove hidden class								
							}
							
							//console.log(slides_elem[sl]);								
						}
						
						var count = slides_elem.length - reset;
						
						slides[i].firstElementChild.setAttribute("style","--animate: none;"); //remove animation
						
						while(count > 0){
							slides[i].append(slides[i].firstElementChild); //append to reset
							count--;
						}
						
						
						for(var h = 0; h < slides_elem.length; h++){
							if(h >= getNumber){
								slides_elem[h].setAttribute("class","hidden"); //add hidden class to carousel based on numbers to hide or show
							}
						}
						
					}
				}
				
			}, 100);
		}		
	}	
 }

function carouselModeEffect(m,e,a){
	for(var i = 0; i < e.length; i++){
		if(m=="moveLeft"){
			if(a=="setStyle"){
				e[i].children[0].setAttribute("style","right: -60%; --animate: none;");
			}
			if(a=="removeStyle"){
				e[i].children[0].removeAttribute("style");
			}
		}
		
		if(m=="moveRight"){
			if(a=="setStyle"){
				e[i].children[0].setAttribute("style","left: -60%; --animate: none;");
			}
			if(a=="removeStyle"){
				e[i].children[0].removeAttribute("style");
			}		
		}
	
	}
} 

setTimeout(
function(e){
	for(var l = 0; l < loader.length; l++){
			loader[l].classList.add("hidden");
	}
},500
);

//arrows keypress function handler
function ArrowsKeypress(id){
	document.addEventListener("keydown", function(e){
		if(slider[id].getAttribute("key") == "active" && slider[id].getAttribute("arrows") != "off"){
			if(e.code == "ArrowRight"){
				if(slider[id].getAttribute("type") != "carousel"){
					pn_slide("Next",id);
				}
				if(slider[id].getAttribute("type") == "carousel" && slider[id].getAttribute("mode") != "facebook"){
					pn_slide("Next",id);
				}
				if(slider[id].getAttribute("type") == "carousel" && slider[id].getAttribute("mode") == "facebook"){
					if(slides[id].firstElementChild.getAttribute("order") != slides[id].children.length){
						pn_slide("Next",id);
					}	
				}	
			}
			if(e.code == "ArrowLeft"){
				if(slider[id].getAttribute("type") != "carousel"){
					pn_slide("Prev",id);
				}
				if(slider[id].getAttribute("type") == "carousel" && slider[id].getAttribute("mode") != "facebook"){
					pn_slide("Prev",id);
				}
				if(slider[id].getAttribute("type") == "carousel" && slider[id].getAttribute("mode") == "facebook"){
					if(slides[id].firstElementChild.getAttribute("order") != 0){
						pn_slide("Prev",id);
					}	
				}							
			}			
		}
	});
}