<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package physioplus
 */

get_header(); ?>
<div class="main-container"><!-- main-container -->
    <div class="container">
      <div class="row">
        <div class="col-md-12 text-center">
            <div class="error-pic">
                <img src="<?php echo get_template_directory_uri(); ?>/images/404-icons.png" class="img-error">
            </div>
            <div class="error-description">
                <h1 class="error-title"><?php esc_html_e( '404 Error','physioplus'); ?></h1>
                <h5 class="small-title left"><?php esc_html_e( 'Page not found','physioplus'); ?></h5>
                <p class="lead"><?php esc_html_e( 'We\'re sorry, the page you were looking for doesn\'t exist anymore.','physioplus'); ?></p>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn btn-default hvr-sweep-to-right"><?php esc_html_e( 'back to home','physioplus'); ?></a>
            </div>
    	</div>
      </div>
    </div>
</div>
<?php
get_footer();
?>