<?php
/*
 * The template for displaying Author bios
 *
 * @package physioplus
 */
 
// If a user has filled out their description, show a bio on their entries.
if ( get_the_author_meta( 'description' ) ) {
?>  
<div class="col-md-12 author-block">
    <div class="author-well"><!--author-well -->
        <div class="row">
            <div class="col-md-4">
                <div class="author-pic zoom-pic"><?php echo get_avatar(get_the_author_meta('ID'),260); ?></div>
            </div>
            <div class="col-md-8 author-desc">
                <div class="author-info"><!-- author info -->
                    <h2><?php echo get_the_author_meta('display_name');?></h2>
                    <h5 class="small-title left"><?php esc_html_e('author','physioplus');?></h5>
                 <?php
                    $author_content = get_the_author_meta('description');
                    if(!empty($author_content))
                    {
                        echo '<p>'.esc_html($author_content).'</p>'; 
                    }
                    else{
                        echo '<p>'.esc_html__('No description.Please update your profile.','physioplus').'</p>'; 
                    }
                 ?>     
              <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID')));?>" class="btn-link" ><?php esc_html_e( 'View All posts', 'physioplus' ); ?></a>
              </div><!-- /.author info --> 
            </div>
        </div>
    </div><!-- /.author-well -->
</div>
<?php } ?>