<?php
/**
 * physioplus functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package physioplus
 */

if ( ! function_exists( 'physioplus_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function physioplus_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on physioplus, use a find and replace
	 * to change 'physioplus' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'physioplus', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	add_theme_support( 'custom-header' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'physioplus' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See https://developer.wordpress.org/themes/functionality/post-formats/
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
		'audio',		
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'physioplus_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

    add_editor_style( '/css/custom-editor-style.css' );		
}
endif;
add_action( 'after_setup_theme', 'physioplus_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function physioplus_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'physioplus_content_width', 640 );
}
add_action( 'after_setup_theme', 'physioplus_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function physioplus_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'physioplus' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'physioplus' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Top', 'physioplus' ),
		'id'            => 'footer-top',
		'description'   => esc_html__( 'Add footer widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer 1', 'physioplus' ),
		'id'            => 'footer-1',
		'description'   => esc_html__( 'Add footer widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );	
	
	register_sidebar( array(
		'name'          => esc_html__( 'Footer 2', 'physioplus' ),
		'id'            => 'footer-2',
		'description'   => esc_html__( 'Add footer widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );	
	register_sidebar( array(
		'name'          => esc_html__( 'Footer 3', 'physioplus' ),
		'id'            => 'footer-3',
		'description'   => esc_html__( 'Add footer widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );		
	register_sidebar( array(
		'name'          => esc_html__( 'Footer 4', 'physioplus' ),
		'id'            => 'footer-4',
		'description'   => esc_html__( 'Add footer widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer 5', 'physioplus' ),
		'id'            => 'footer-5',
		'description'   => esc_html__( 'Add footer widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );	
	register_sidebar( array(
		'name'          => esc_html__( 'Page Sidebar', 'physioplus' ),
		'id'            => 'sidebar-page',
		'description'   => esc_html__( 'Add page widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s widget">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );			

	register_sidebar( array(
		'name'          => esc_html__( 'Service Single', 'physioplus' ),
		'id'            => 'sidebar-service',
		'description'   => esc_html__( 'Add widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s widget">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );		

	register_sidebar( array(
		'name'          => esc_html__( 'Career Single', 'physioplus' ),
		'id'            => 'sidebar-career',
		'description'   => esc_html__( 'Add widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s widget">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) );				

}
add_action( 'widgets_init', 'physioplus_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function physioplus_scripts() {
	
	$google_map_key=thegenius_get_option('google_map_key');
	
	wp_enqueue_style( 'physioplus-style', get_stylesheet_uri() );

	// Bootstrap 
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() .'/css/bootstrap.min.css','', '3.3.6' );	

	// Custom - style
	wp_enqueue_style( 'physioplus-custom-style', get_template_directory_uri() .'/css/custom-style.css');	

	// Menu - style
	wp_enqueue_style( 'menumaker', get_template_directory_uri() .'/css/menumaker.css');		

	// Font Awesome
	wp_enqueue_style( 'font-awesome-min', get_template_directory_uri() .'/css/font-awesome.min.css','', '4.4.0' );

	// Custom - style
	wp_enqueue_style( 'flaticon', get_template_directory_uri() .'/css/flaticon.css');

	// animate - style
	wp_enqueue_style( 'animate', get_template_directory_uri() .'/css/animate.css');	

	// OWl
	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() .'/css/owl.carousel.css' );	
	wp_enqueue_style( 'owl-theme', get_template_directory_uri() .'/css/owl.theme.css' );	
	wp_enqueue_style( 'owl-transitions', get_template_directory_uri() .'/css/owl.transitions.css');	


	// Bootstrap JS
	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), null, true );	

	wp_enqueue_script( 'owl-carousel-min', get_template_directory_uri() . '/js/owl.carousel.min.js', array(), null, true );	
	
	// Menumaker JS
	wp_enqueue_script( 'menumaker', get_template_directory_uri() . '/js/menumaker.js', array(), null, true );			

	wp_enqueue_script( 'bootstrap-dropdown-hover', get_template_directory_uri() . '/js/jquery.bootstrap-dropdown-hover.min.js', array(), null, true );			

	wp_enqueue_script( 'sticky', get_template_directory_uri() . '/js/jquery.sticky.js', array(), null, true );			


	wp_enqueue_script( 'isotope-pkgd-min', get_template_directory_uri() . '/js/isotope.pkgd.min.js', array(), null, true );

	if(is_page_template('page-templates/gallery-filter.php'))
	{
		// Magnific popup
		wp_enqueue_style( 'magnific-popup', get_template_directory_uri() .'/css/magnific-popup.css' );	
	
		wp_enqueue_script( 'jquery-isotope', get_template_directory_uri() . '/js/jquery.isotope.min.js', array(), null, true );
		wp_enqueue_script( 'jquery-magnific-popup', get_template_directory_uri() . '/js/jquery.magnific-popup.min.js', array(), null, true );
		// jquery isotope min	
		wp_enqueue_script( 'physioplus-gallery-filter', get_template_directory_uri() . '/js/gallery-filter.js', array(), null, true );
		wp_enqueue_script( 'jquery-popup-gallery', get_template_directory_uri() . '/js/popup-gallery.js', array(), null, true );				
	}	
	
	if(is_singular( 'gallery' ) )
	{
		// Magnific popup
		wp_enqueue_style( 'magnific-popup', get_template_directory_uri() .'/css/magnific-popup.css' );			
		wp_enqueue_script( 'jquery-magnific-popup', get_template_directory_uri() . '/js/jquery.magnific-popup.min.js', array(), null, true );

		wp_enqueue_script( 'jquery-popup-gallery', get_template_directory_uri() . '/js/popup-gallery.js', array(), null, true );
	}

	if(is_page_template('page-templates/branches.php'))
	{
		if(!empty($google_map_key))
		{
			wp_enqueue_script( 'maps-googleapis', 'http'. (is_ssl() ? 's' : '').'://maps.googleapis.com/maps/api/js?key='.$google_map_key, array(), null, true);
		}
		else
		{
			wp_enqueue_script( 'maps-googleapis', 'http'. (is_ssl() ? 's' : '').'://maps.googleapis.com/maps/api/js', array(), null, true);
		}
		
		wp_enqueue_script( 'physioplus-google-map-load', get_template_directory_uri() . '/js/google-map.js', array(), null, true);	
	}	


	if(is_singular( 'branches' ) )
	{
		if(!empty($google_map_key))
		{
			wp_enqueue_script( 'maps-googleapis', 'http'. (is_ssl() ? 's' : '').'://maps.googleapis.com/maps/api/js?key='.$google_map_key, array(), null, true);
		}
		else
		{
			wp_enqueue_script( 'maps-googleapis', 'http'. (is_ssl() ? 's' : '').'://maps.googleapis.com/maps/api/js', array(), null, true);
		}
		wp_enqueue_script( 'physioplus-single-map', get_template_directory_uri() . '/js/single-map.js', array(), null, true);		
	}
	

	wp_enqueue_style( 'physioplus-prefix-fonts', physioplus_prefix_fonts_url(), array(), null );

	wp_enqueue_script( 'physioplus-custom-script', get_template_directory_uri() . '/js/custom-script.js', array(), null, true );	

	wp_enqueue_script( 'physioplus-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );

	wp_enqueue_script( 'physioplus-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'physioplus_scripts' );


/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/general-function.php';


/**
 * TGM Load.
 */
require get_template_directory() . '/inc/plugin/physioplus-plugin.php';

/**
 * Custom menu for nav walker.
 */
require get_template_directory() . '/inc/nav-menu-walker.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/framework/init.php';


/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
