<?php 
/**
 * 	Pagination 
 */
if ( ! function_exists( 'physioplus_pagination' ) ) :
/**
 * Display navigation to next/previous set of posts when applicable.
 *
 * @since Devote 1.0
 *
 * @global WP_Query   $wp_query   WordPress Query object.
 * @global WP_Rewrite $wp_rewrite WordPress Rewrite object.
 */
function physioplus_pagination() {
	global $wp_query, $wp_rewrite;

	// Don't print empty markup if there's only one page.
	if ( $wp_query->max_num_pages < 2 ) {
		return;
	}

	$paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
	$pagenum_link = html_entity_decode( get_pagenum_link() );
	$query_args   = array();
	$url_parts    = explode( '?', $pagenum_link );

	if ( isset( $url_parts[1] ) ) {
		wp_parse_str( $url_parts[1], $query_args );
	}

	$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
	$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

	$format  = $wp_rewrite->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
	$format .= $wp_rewrite->using_permalinks() ? user_trailingslashit( $wp_rewrite->pagination_base . '/%#%', 'paged' ) : '?paged=%#%';

	// Set up paginated links.
	$links = paginate_links( array(
		'base'     => $pagenum_link,
		'format'   => $format,
		'total'    => $wp_query->max_num_pages,
		'current'  => $paged,
		'mid_size' => 1,
		'add_args' => array_map( 'urlencode', $query_args ),
		'prev_text' => esc_html__('Previous','physioplus'),
		'next_text' => esc_html__('Next','physioplus'),
	) );

	if ( $links ) :
	?>
        <div class="col-md-12 st-pagination">
            <div class="pagination">
                <?php echo wp_kses($links,array('a' => array('class' => array(),'href' => array()),'li' => array('class' => array()),'span' => array('class' => array()),'i' => array('class' => array())));					
				 ?>
            </div>
        </div><!-- .md 12 -->
	<?php
	endif;
}
endif; 



/**
 * 	Related Post.
 */
if ( ! function_exists( 'physioplus_related_post' ) ) :
 
function physioplus_related_post() {

	global $post;
	$original_post ="";
	$categories = get_the_category($post->ID);
	
	if ($categories) {
	echo '<div class="col-md-12 related-post-block"><div class="row"><div class="col-md-12"><h2>';
	esc_html_e('Related Post','physioplus');
	echo '</h2></div>';	
	
			$category_ids = array();		
			foreach($categories as $individual_category) $category_ids[] = $individual_category->term_id;		
				$args=array(
					'category__in' => $category_ids,
					'post__not_in' => array($post->ID),
					'posts_per_page'=> 2, // Number of related posts that will be shown.
					'ignore_sticky_posts'=>1
				);				
				$related_post_query = new wp_query( $args );
				if( $related_post_query->have_posts() ) {	
					while( $related_post_query->have_posts() ) {
						$related_post_query->the_post(); 
						?>
                        <div class="col-md-6 related-post">
                        <h3><a href="<?php the_permalink()?>" class="post-title"><?php the_title(); ?></a></h3>  
						<span><?php esc_html_e('In','physioplus'); ?> 
                        <?php 
						$categories = get_the_category();
						$separator = ' , ';
						$output = '';
						if ( ! empty( $categories ) ) {
							foreach( $categories as $category ) {
								$output .= '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" title="' . esc_attr( sprintf( esc_html__( 'View all posts in %s', 'physioplus' ), $category->name ) ) . '">"' . esc_html( $category->name ) . '"</a> ' . $separator;
							}
							echo trim( $output, $separator );
						}
						?>
						</span>
                        </div>
						<?php
				} // if
			} // foreach
			echo '</div></div>';
	} // if			
	$post = $original_post;
	wp_reset_postdata();
}

endif; 

// single post pre next

if ( ! function_exists( 'physioplus_single_post_pre_next' ) ) :

function physioplus_single_post_pre_next() {
	 $p = get_adjacent_post(false, '', true); 
	 $n = get_adjacent_post(false, '', false);
	 if(!empty($p) || !empty($n)){
 		echo '<div class="col-md-12 next-prev-block"><div class="row">';
		
        // previous post title with link 
        if(!empty($p))
		printf('<div class="col-md-6 next-post"><a href="%s" class="next-link"><span>'.esc_html__('Previous','physioplus').'</span> </a><h3><a href="%s" title="%s" class="post-title">%s</a></h3></div>', get_permalink($p->ID), get_permalink($p->ID) , $p->post_title , $p->post_title  );
	                
		// next post title with link 
		if(!empty($n))
		printf('<div class="col-md-6 prev-post  pull-right"> <a href="%s" class="prev-link"><span>'.esc_html__('Next','physioplus').'</span></a><h3><a href="%s" title="%s" class="post-title">%s</a></h3></div>', get_permalink($n->ID), get_permalink($n->ID), $n->post_title , $n->post_title ); 
				
 		echo '</div></div>';
	 }		
}

endif; 


// Comment list block html

if ( ! function_exists( 'physioplus_shape_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @since Shape 1.0
 */
function physioplus_shape_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}
?>
	<<?php echo esc_html($tag) ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	<?php endif; ?>
	   	<div class="comment-section">
            <div class="comment-frame">      			
                <div class="user-pic">
                    <?php if (0 != $args['avatar_size']) echo get_avatar($comment, $args['avatar_size'] ); ?>
                </div>
            </div>
            <div class="tex-box user-comment">
                 <div class="comment-body">
                    <h3 class="comment-title"><?php 
                        printf(__('%s', 'physioplus'), sprintf('%s', get_comment_author_link())); ?>
                   </h3>
                    <div class="meta-style">
                        <span class="meta-date"><i class="fa fa-calendar-check-o"></i><?php 
                            comment_time('d, F,Y');	?>&nbsp;&nbsp;
                        <?php 
                            echo human_time_diff( get_comment_time('U'), current_time('timestamp') ) . ' ago'; ?>
                        </span><?php 
                            edit_comment_link( esc_html__( '(Edit)', 'physioplus' ), ' ' ); ?> 
                    </div> <!-- meta -->
                    <div class="comment-box">
                    <?php if ( $comment->comment_approved == '0' ) : ?>
                        <em><?php esc_html_e( 'Your comment is awaiting moderation.', 'physioplus' ); ?></em>
                        <br />
                    <?php endif; ?>
                    <?php comment_text(); ?>
                    </div>										
                    <?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
                 </div><!-- media-body -->
            </div>
        </div>
	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; 
}
endif; // ends check for physioplus_shape_comment()

/**
*  The Blog post video iframe support browser.
*/
if(!function_exists('physioplus_video_embed')){
    function physioplus_video_embed($embed_code){
		$embed_code=str_replace('webkitallowfullscreen','',$embed_code);
		$embed_code=str_replace('mozallowfullscreen','',$embed_code);
		$embed_code=str_replace('frameborder="0"','',$embed_code);
		$embed_code=str_replace('frameborder="no"','',$embed_code);
		$embed_code=str_replace('scrolling="no"','',$embed_code);
		$embed_code=str_replace('&','&amp;',$embed_code);
		return $embed_code;
	}
}


// Replace class on comment link
add_filter('comment_reply_link', 'physioplus_replace_reply_link_class');

function physioplus_replace_reply_link_class($class){
    $class = str_replace("class='comment-reply-link", "class='btn btn-default btn-xs hvr-sweep-to-right", $class);
    return $class;
}


// enqueue_scripts: make sure to include ajaxurl, so we know where to send the post request
function physioplus_load_add_main_js(){
  
  wp_register_script( 'physioplus-functions-script', get_template_directory_uri() . '/js/functions.js', array( 'jquery' ), '2.0', false );
  wp_enqueue_script( 'physioplus-functions-script' );
  wp_localize_script( 'physioplus-functions-script', 'physioplus_functions_obj', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ),'ajax_nonce' =>  wp_create_nonce('ajax_physioplus_loadmore'), 'templateurl' => get_template_directory_uri(), 'posts_per_page' => get_option('posts_per_page') ) );
  
}
add_action( 'wp_enqueue_scripts', 'physioplus_load_add_main_js', 90);



add_action( 'wp_ajax_nopriv_physioplus_load_more', 'physioplus_blog_masonry_more_func' );
add_action( 'wp_ajax_physioplus_load_more', 'physioplus_blog_masonry_more_func' );  


//function return new posts based on offset and posts per page value
function physioplus_blog_masonry_more_func() {
  //verifying nonce here
  check_ajax_referer( 'ajax_physioplus_loadmore', 'security' );
 
  $offset = isset($_REQUEST['offset'])?intval($_REQUEST['offset']):0;
  $posts_per_page = isset($_REQUEST['posts_per_page'])?intval($_REQUEST['posts_per_page']):get_option('posts_per_page');
  //optional, if post type is not defined use regular post type
  $post_type = 'post';
  
  
  ob_start(); // buffer output instead of echoing it
  $args = array(
	  			'post_type'=>$post_type,
				'offset' => $offset,
				'posts_per_page' => $posts_per_page,
				'orderby' => 'date',
				'order' => 'DESC'
					);
  $posts_query = new WP_Query( $args );
  
  
  if ($posts_query->have_posts()) {
	  //if we have posts:
		  $result['have_posts'] = true; //set result array item "have_posts" to true
		  
		while ( $posts_query->have_posts() ) : $posts_query->the_post();

		get_template_part( 'template-parts/content', 'grid' );

		endwhile;

		$result['html'] = ob_get_clean(); // put alloutput data into "html" item
  } else {
	  //no posts found
	  $result['have_posts'] = false; // return that there is no posts found
  } 
   echo json_encode($result); // by echo we return JSON feed on POST request sent via AJAX

  die();
}


if ( ! function_exists( 'physioplus_prefix_fonts_url' ) ) :
/**
 * Register Google fonts.
 *
 * @return string Google fonts URL for the theme.
 */
function physioplus_prefix_fonts_url() {
    $fonts_url = '';
    $fonts     = array();
    $subsets   = '';

	 $google_font = thegenius_get_option('google_font');		 
	 $google_font_family = "";
	 $google_font_family = isset($google_font)?$google_font:'Roboto:400,400italic,500,500italic,700,700italic,300,300italic';

	 $heading_google_font = thegenius_get_option('heading_google_font');		 
	 $heading_google_font_family = isset($heading_google_font)?$heading_google_font:'Adamina';		 

   /* translators: If there are characters in your language that are not supported by this font, translate this to 'off'. Do not translate into your own language. */
    if ( 'off' !== esc_html_x( 'on', 'Adamina font: on or off', 'physioplus' ) ) {
        $fonts[] = $heading_google_font_family;
    }

    /* translators: If there are characters in your language that are not supported by this font, translate this to 'off'. Do not translate into your own language. */
    if ( 'off' !== esc_html_x( 'on', 'Roboto font: on or off', 'physioplus' ) ) {
        $fonts[] = $google_font_family;
    }

    if ( $fonts ) {
        $fonts_url = add_query_arg( array(
            'family' => urlencode( implode( '|', $fonts ) ),
            'subset' => urlencode( $subsets ),
        ), 'https://fonts.googleapis.com/css' );
    }

    return $fonts_url;
}
endif;
?>