<?php
/**
 *  Template Name:  Filter Gallery
 *
 * @package physioplus
 */

get_header(); 
?>
<div class="main-container">
  <div class="container">
	<?php while ( have_posts() ) : the_post(); ?>
    <div class="row">
        <div class="col-md-12 mbtm-2">
            <?php the_content(); ?>
        </div>
    </div>
    <?php endwhile; // End of the loop. ?>  
    <div class="row">
      	<?php 
		$filter_gallery_html='';
		$gallery_result_html='';		

		$args = array( 'post_type' => 'gallery', 'posts_per_page' => -1,'orderby' => 'menu_order ID','order'   => 'ASC' );
		$gallery = new WP_Query( $args );
		$total_element=count($gallery->posts);
		if($total_element!=0)
		{
			$filter_gallery_html .= '<a href="#" data-filter="*" class="current">'.esc_html__( 'All', 'physioplus').'</a>';				
		}
        while ( $gallery->have_posts() ) : $gallery->the_post();
		$gallery_data = get_post_meta( $post->ID, 'gallery_data', true );

		if ( isset( $gallery_data['single_image_url'] ) ) 
		{
					
		$filter_gallery_html .= '<a href="#" data-filter=".'.esc_attr(str_replace(" ","-",strtolower(get_the_title($post->ID)))).'" class="">'.esc_html(get_the_title($post->ID)).'</a>';

			for( $i = 0; $i < count( $gallery_data['single_image_url'] ); $i++ ) 
			{
				$gallery_result_html.='<div class="'.esc_attr(str_replace(" ","-",strtolower(get_the_title($post->ID)))).' col-md-3">
							<a href="'.esc_url($gallery_data['single_image_url'][$i]).'" title="'.esc_attr($gallery_data['image_title'][$i]).'" class="image-link" ><img src="'.esc_url($gallery_data['single_image_url'][$i]).'" alt="'.esc_attr($gallery_data['image_title'][$i]).'" class="img-responsive">
							</a>
					</div>';				
			}
			
		}	
		endwhile; 		
		wp_reset_postdata();		
		?>    
        <div class="col-md-12 text-center">
        <?php echo '<div class="portfolioFilter">'.$filter_gallery_html.'</div>';?>
            <div class="popup-gallery">
                <div class="portfolioContainer">
                    <?php echo wp_kses_post($gallery_result_html); ?>
                </div>
            </div>
      	</div>
      </div>
  </div>
</div>
<?php get_footer(); ?>