<?php
/**
 *  Template Name: Therapist Template
 *
 * @package physioplus
 */

get_header(); 
?>

<div class="main-container">
  <div class="container">
	<?php while ( have_posts() ) : the_post(); ?>
    <div class="row">
        <div class="col-md-12">
            <?php the_content(); ?>
        </div>
    </div>
    <?php endwhile; // End of the loop. ?>  
    <div class="row">
      <?php 
        $args = array( 'post_type' => 'therapist', 'posts_per_page' => -1,'post_parent' => 0,'orderby' => 'menu_order ID','order'   => 'ASC' );
        $therapist = new WP_Query( $args );
		while ( $therapist->have_posts() ) : $therapist->the_post();

        $meta_therapist_designation = get_post_meta( $post->ID, 'therapist_designation', true );		
	?>
	<div class="col-md-4 trainer-block">
        <div class="trainer-pic zoom-pic"> <a href="<?php the_permalink(); ?>">
 		<?php 
		if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
		   the_post_thumbnail( 'full' ,array( 'class' => 'img-responsive' )  );
		}
		?>
         </a></div>
        <div class="trainer-caption">
          <h2><a class="trainer-title" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
          <?php
		  if($meta_therapist_designation)
          {
			  echo '<span class="trainer-meta">'.$meta_therapist_designation.'</span>';
		  }
		  ?>
          </div>
      </div>
	<?php 
		endwhile; 		
		wp_reset_postdata();
		?>
    </div>
  </div>
</div>
<?php get_footer(); ?>
