<?php
/**
 * The template for displaying all Doctor posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package physioplus
 */

get_header(); ?>
<div class="main-container"><!-- main-container -->
  <div class="container">
    <?php 

	while ( have_posts() ) : the_post();

	$branches_html='';
	$branches_address = get_post_meta( $post->ID, 'branches_address', true );
	$branches_email = get_post_meta( $post->ID, 'branches_email', true );
	$branches_phone = get_post_meta( $post->ID, 'branches_phone', true );

	$locators = get_post_meta( $post->ID, 'locators', true );

	$branches_longitude = $locators['longitude'];
	$branches_latitude = $locators['latitude'];
	
	$careers = get_post_meta($post->ID,'career_options',true);
	$careers_post_id = get_the_ID();
	$location_name = get_the_title();			
	?>    
    <div class="row">
      <div class="col-md-12 location-map">
        <div class="map" id="googleMap"> </div>
      </div>
      <div class="col-md-offset-1 col-md-10 well-block location-contact">
        <div class="row">
          <div class="col-md-5 location-cnt-block">
            <h2><?php esc_html_e('Contact Details','physioplus');?></h2>
            <div class="contact-information">
              <?php 			  
				if(isset($branches_address))
				{
					echo '<div class="address-block"><div class="icon"><i class="flaticon-big104"></i></div><p>'.$branches_address.'</p></div>';
				}
		
				if(isset($branches_email))
				{
					echo '<div class="email-block"><div class="icon"><i class="flaticon-opened25"></i></div><p><a href="mailto:'.$branches_email.'">'.$branches_email.'</p></a></div>';				
				}
				if(isset($branches_phone))
				{
					echo '<div class="call-block"><div class="icon"><i class="flaticon-cellphone55"></i></div><p>'.$branches_phone.'</p></div>';				
				}	
			  
			  // Make appointment option
			  if(thegenius_get_option('general_check_appnt_btn')!=""){
				echo '<a href="'.esc_url(thegenius_get_option('general_appnt_btn_url')).'" class="btn btn-default hvr-sweep-to-right">'.thegenius_get_option('general_appnt_btn_text').'</a>';
				}
			  
			  ?>              
              </div>
          </div>
          <div class="col-md-7 timing-hours">
            <h2 class="time-hours-title"><?php esc_html_e('Opening Hours','physioplus') ?></h2>
            <ul class="list-group listnone">
              <?php 
			   //get the saved meta time table arry
                $time = get_post_meta($post->ID,'time',true);
                $time_table_html='';
                
	  			if(is_array($time))				
	  			{
					foreach($time as $timing)
					{
						$time_table_html.='<li class="list-group-item"><span class="time-badge">'.$timing['time'].'</span> '.$timing['consult'].'</li>';
					}
				}
                echo wp_kses($time_table_html,array('ul' => array('class' => array()),'li' => array('class' => array()),'span' => array('class' => array())));
			  ?>
            </ul>
          </div>
        </div>
      </div>
      <div class="col-md-12"><?php the_content(); ?></div>
    </div>
    <div class="row">
    <?php  
	
		$args = array( 'post_type' => 'career', 'posts_per_page' => -1,'orderby' => 'menu_order ID','order' => 'ASC' );
		$career = new WP_Query( $args );
		$career_html='';
		$career_timing_html='';
		$career_education_html='';
		$career_experience_html='';

		while ( $career->have_posts() ) : $career->the_post();
		
		$career_branch_meta=get_post_meta( get_the_ID(), 'career_branch', true );	

		if($careers_post_id==$career_branch_meta && $career_branch_meta!=0)
		{
			$career_timing = get_post_meta($post->ID,'career_timing',true);
			$career_education = get_post_meta($post->ID,'career_education',true);	
			$career_experience = get_post_meta($post->ID,'career_experience',true);

			if(!empty($career_timing))
			{
				$career_timing_html='<span class="job-degree"> <i class="fa fa-clock-o"></i>'.$career_timing.'</span>';
			}
			if(!empty($career_education))
			{
				$career_education_html='<span class="job-degree"> <i class="fa fa-graduation-cap"></i>'.$career_education.'</span>';
			}
			if(!empty($career_experience))
			{
				$career_experience_html='<span class="job-exp"> <i class="fa fa-coffee"></i>'.$career_experience.'</span>';
			}	

			$career_html.='<li class="list-group-item job-list">
              <h3><a href="'.get_permalink().'" class="job-title">'.get_the_title().'</a></h3>
              '.$career_timing_html.$career_education_html.$career_experience_html.' <a href="'.get_permalink().'" class="btn-link pull-right arrow-link"><i class="flaticon-right139"></i></a> </li>';			
		}
		
		endwhile; 		
		wp_reset_postdata();
		
		if(!empty($career_html))
		{
			echo '<div class="col-md-6 current-job-block"><div class="current-job-listing"><h2>'.esc_html__('Current Openings Jobs','physioplus').'</h2><h5 class="small-title left">'.$location_name.'</h5><ul class="list-group listnone">';
			echo wp_kses($career_html,array('a' => array('class' => array(),'href' => array()),'li' => array('class' => array()),'h3' => array('class' => array()),'span' => array('class' => array()),'i' => array('class' => array())));	
	
			echo '</ul></div></div>';
		}
		?>
	<?php 
	$google_map_arr='["'.get_the_title().'", '.$branches_longitude.', '.$branches_latitude.',1]';	
	endwhile; ?>
	</div>
  </div>
</div>
<!-- /.main container -->
<script>
// Data for the markers consisting of a name, a LatLng and a zIndex for the
// order in which these markers should display on top of each other.
var center_point =  {"lat":<?php echo floatval($branches_latitude); ?>,"lng":<?php echo floatval($branches_longitude); ?>,"marker":'<?php echo get_template_directory_uri(); ?>/images/marker.png'};
</script>
<?php get_footer(); ?>    