<?php
/**
 * The template for displaying all Doctor posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package physioplus
 */

get_header(); ?>
<div class="main-container"><!-- main container -->
  <div class="container">
    <div class="row">
      <?php while ( have_posts() ) : the_post(); 
      $career_branch = get_post_meta($post->ID,'career_branch',true);
	  $career_timing = get_post_meta($post->ID,'career_timing',true);
	  $career_education = get_post_meta($post->ID,'career_education',true);	
	  $career_experience = get_post_meta($post->ID,'career_experience',true);
	  ?>
      <div class="col-md-8">
        <div class="row">
          <div class="col-md-12">
              <div class="job-meta">
			  <?php 
				if(!empty($career_branch) && $career_branch!=0)
				{
					echo '<span class="job-location"> <i class="fa fa-map-marker"></i>'.get_the_title( $career_branch ).'</span>';
				}
				if(!empty($career_timing))
				{
					echo '<span class="job-degree"> <i class="fa fa-clock-o"></i>'.$career_timing.'</span>';
				}
				if(!empty($career_education))
				{
					echo '<span class="job-degree"> <i class="fa fa-graduation-cap"></i>'.$career_education.'</span>';
				}
				if(!empty($career_experience))
				{
					echo '<span class="job-exp"> <i class="fa fa-coffee"></i>'.$career_experience.'</span>';
				}				
			  ?>
              </div>
			<?php the_content(); ?>
          </div>
        </div>
      </div>
      <?php endwhile; ?>
      <div class="col-md-4 sidebar">
		<?php if ( is_active_sidebar( 'sidebar-career' ) ) { ?>
            <?php dynamic_sidebar( 'sidebar-career' ); ?>
        <?php } ?>          
      </div>
    </div>
  </div>
</div>
<!-- /.main container -->
<?php get_footer(); ?>    