<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package physioplus
 */
	
?>
<div class="navbar-top"><!-- navbar-top-start -->
  <div class="container">
     <?php echo thegenius_get_option('topbar_content2'); ?>
  </div>
</div>
<!-- /.navbar-top-end -->
<div class="collapse" id="collapseExample">
  <div class="container">
    <div class="well-block">
      <div class="row">
        <div class="col-md-12">
          <form method="get" class="" action="<?php echo esc_url(home_url( '/' )); ?>">
          <div class="input-group">          
            <input type="text" class="form-control"  name="s" placeholder="<?php esc_attr_e('Search','physioplus');?>" value="<?php echo esc_attr(get_search_query());?>">
            <span class="input-group-btn">
            <button class="btn btn-default" type="submit"><?php esc_html_e('Go','physioplus');?>!</button>
            </span> </div>
          <!-- /input-group --> 
		   </form>	
        </div>
        <!-- /.col-lg-6 --> 
      </div>
    </div>
  </div>
</div>
<div class="navigation"><!-- navigation-start -->
  <nav class="navbar navbar-default">
    <div class="container"> 
      <!-- Brand and toggle get grouped for better mobile display -->
      <div class="navbar-header">
			<?php 
            if(thegenius_get_option('checker')!=""){ ?>
            <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
            	<?php } else{ ?>		
            <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
            <?php if(thegenius_get_option('logo')!=""){ 	?>
            	<img src="<?php echo esc_url(thegenius_get_option('logo')); ?>" alt="<?php bloginfo( 'name' ); ?>" class="img-responsive">
            <?php 	
            } else {?>
            	<img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="<?php bloginfo( 'name' ); ?>" class="img-responsive">
            <?php } ?>
            </a>      
            <?php } ?>  

	  </div>      
      <div id="cssmenu">
        <?php 
             if ( has_nav_menu( 'primary' ) ) {
                wp_nav_menu( array( 
                'theme_location' => 'primary',
                  'container'=>false,
                  'walker'=>new Physioplus_Tg_Menu(),
                  'menu_class'=>'nav navbar-nav navbar-right',
                ) );
            }
        ?>        
      </div>
      <!-- /.navbar-collapse --> 
    </div>
    <!-- /.container-end --> 
  </nav>
</div>
<!-- /.navigation-end -->
