<?php 
/*
* List of custom post type for physio
*/

add_action('init', 'physioplus_slider_register');

function physioplus_slider_register() {
    register_post_type('slider', array(
        'label' => esc_html__('Slider','physio'),
        'description' => '',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'capability_type' => 'post',
        'map_meta_cap' => true,
        'hierarchical' => true,
        'rewrite' => array('slug' => 'slider', 'with_front' => true),
        'query_var' => true,
        'menu_position' => '500',        
        'menu_icon'   => 'dashicons-images-alt2',
        'supports' => array('title', 'thumbnail',  'page-attributes'),
        'labels' => array(
            'name' => esc_html__('Slider','physio'),
            'singular_name' => esc_html__('Slider','physio'),
            'menu_name' => esc_html__('Slider','physio'),
            'add_new' => esc_html__('Add Slider','physio'),
            'add_new_item' => esc_html__('Add New Slider','physio'),
            'edit' => esc_html__('Edit Slider','physio'),
            'edit_item' => esc_html__('Edit Slider','physio'),
            'new_item' => esc_html__('New Slider','physio'),
            'view' => esc_html__('View Slider','physio'),
            'view_item' => esc_html__('View Slider','physio'),
            'search_items' => esc_html__('Search Slider','physio'),
            'not_found' => esc_html__('No Slider Found','physio'),
            'not_found_in_trash' => esc_html__('No Slider Found in Trash','physio'),
            'parent' => esc_html__('Parent Slider','physio'),
        )
    ));
}

// Custom Therapist post

add_action('init', 'physioplus_therapist_register');

function physioplus_therapist_register() {
    register_post_type('therapist', array(
        'label' => esc_html__('Therapist','physio'),
        'description' => '',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'capability_type' => 'post',
        'map_meta_cap' => true,
        'hierarchical' => true,
        'rewrite' => array('slug' => 'therapist', 'with_front' => true),
        'query_var' => true,
        'menu_position' => '500',        
        'menu_icon'   => 'dashicons-businessman',
        'supports' => array('title', 'editor', 'excerpt', 'custom-fields', 'thumbnail',  'page-attributes'),
        'labels' => array(
            'name' => esc_html__('Therapist','physio'),
            'singular_name' => esc_html__('Therapist','physio'),
            'menu_name' => esc_html__('Therapist','physio'),
            'add_new' => esc_html__('Add Therapist','physio'),
            'add_new_item' => esc_html__('Add New Therapist','physio'),
            'edit' => esc_html__('Edit Therapist','physio'),
            'edit_item' => esc_html__('Edit Therapist','physio'),
            'new_item' => esc_html__('New Therapist','physio'),
            'view' => esc_html__('View Therapist','physio'),
            'view_item' => esc_html__('View Therapist','physio'),
            'search_items' => esc_html__('Search Therapist','physio'),
            'not_found' => esc_html__('No Therapist Found','physio'),
            'not_found_in_trash' => esc_html__('No Therapist Found in Trash','physio'),
            'parent' => esc_html__('Parent Therapist','physio'),
        )
    ));
}

// Custom Service post

add_action('init', 'physioplus_services_register');

function physioplus_services_register() {
    register_post_type('service', array(
        'label' => esc_html__('Service','physio'),
        'description' => '',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'capability_type' => 'post',
        'map_meta_cap' => true,
        'hierarchical' => true,
        'rewrite' => array('slug' => 'service', 'with_front' => true),
        'query_var' => true,
        'menu_position' => '500',        
        'menu_icon'   => 'dashicons-smiley',
        'supports' => array('title', 'editor', 'excerpt', 'custom-fields', 'thumbnail',  'page-attributes'),
        'labels' => array(
            'name' => '',
            'singular_name' => esc_html__('Service','physio'),
            'menu_name' => esc_html__('Service','physio'),
            'add_new' => esc_html__('Add Service','physio'),
            'add_new_item' => esc_html__('Add New Service','physio'),
            'edit' => esc_html__('Edit Service','physio'),
            'edit_item' => esc_html__('Edit Service','physio'),
            'new_item' => esc_html__('New Service','physio'),
            'view' => esc_html__('View Service','physio'),
            'view_item' => esc_html__('View Service','physio'),
            'search_items' => esc_html__('Search Service','physio'),
            'not_found' => esc_html__('No Service Found','physio'),
            'not_found_in_trash' => esc_html__('No Service Found in Trash','physio'),
            'parent' => esc_html__('Parent Service','physio'),
        )
    ));
}


//Gallery  post
add_action('init', 'physioplus_gallery_register');

function physioplus_gallery_register() {
    register_post_type('gallery', array(
        'label' => esc_html__('Gallery','physio'),
        'description' => esc_html__('Gallery','physio'),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'capability_type' => 'post',
        'map_meta_cap' => true,
        'hierarchical' => true,
        'show_in_nav_menus' => true,         
        'rewrite' => array('slug' => 'gallery', 'with_front' => true),
        'query_var' => true,
        'menu_position' => '5',
        'menu_icon'   => 'dashicons-format-gallery',
        'supports' => array('title', 'editor','thumbnail', 'page-attributes'),
        'labels' => array(
            'name' => esc_html__('Gallery','physio'),
            'singular_name' => esc_html__('Gallery','physio'),
            'menu_name' => esc_html__('Gallery','physio'),
            'add_new' => esc_html__('Add Gallery','physio'),
            'add_new_item' => esc_html__('Add New Gallery','physio'),
            'edit' => esc_html__('Edit Gallery','physio'),
            'edit_item' => esc_html__('Edit Gallery','physio'),
            'new_item' => esc_html__('New Gallery','physio'),
            'view' => esc_html__('View Gallery','physio'),
            'view_item' => esc_html__('View Gallery','physio'),
            'search_items' => esc_html__('Search Gallery','physio'),
            'not_found' => esc_html__('No Gallery Found','physio'),
            'not_found_in_trash' => esc_html__('No Gallery Found in Trash','physio'),
            'parent' => esc_html__('Parent Gallery','physio'),
        )
    ));
}

// Custom Testimonial post

add_action('init', 'physioplus_testimonial_register');

function physioplus_testimonial_register() {
    register_post_type('testimonial', array(
        'label' => esc_html__('Testimonial','physio'),
        'description' => '',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'capability_type' => 'post',
        'map_meta_cap' => true,
        'hierarchical' => false,
        'rewrite' => array('slug' => 'testimonial', 'with_front' => true),
        'query_var' => true,
        'menu_position' => '600',        
        'menu_icon'   => 'dashicons-testimonial',
        'supports' => array('title', 'page-attributes','thumbnail',),		
        'labels' => array(
            'name' => esc_html__('Testimonial','physio'),
            'singular_name' => esc_html__('Testimonial','physio'),
            'menu_name' => esc_html__('Testimonial','physio'),
            'add_new' => esc_html__('Add Testimonial','physio'),
            'add_new_item' => esc_html__('Add New Testimonial','physio'),
            'edit' => esc_html__('Edit Testimonial','physio'),
            'edit_item' => esc_html__('Edit Testimonial','physio'),
            'new_item' => esc_html__('New Testimonial','physio'),
            'view' => esc_html__('View Testimonial','physio'),
            'view_item' => esc_html__('View Testimonial','physio'),
            'search_items' => esc_html__('Search Testimonial','physio'),
            'not_found' => esc_html__('No Testimonial Found','physio'),
            'not_found_in_trash' => esc_html__('No Testimonial Found in Trash','physio'),
            'parent' => esc_html__('Parent Testimonial','physio'),
        )
    ));
}

// Custom Branches post

add_action('init', 'physioplus_branches_register');

function physioplus_branches_register() {
    register_post_type('branches', array(
        'label' => esc_html__('Branches','physio'),
        'description' => '',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'capability_type' => 'post',
        'map_meta_cap' => true,
        'hierarchical' => false,
        'rewrite' => array('slug' => 'branches', 'with_front' => true),
        'query_var' => true,
        'menu_position' => '1200',        
        'menu_icon'   => 'dashicons-store',
        'supports' => array('title','excerpt', 'editor','thumbnail', 'page-attributes'),
        'labels' => array(
            'name' => esc_html__('Branches','physio'),
            'singular_name' => esc_html__('Branches','physio'),
            'menu_name' => esc_html__('Branches','physio'),
            'add_new' => esc_html__('Add Branches','physio'),
            'add_new_item' => esc_html__('Add New Branches','physio'),
            'edit' => esc_html__('Edit Branches','physio'),
            'edit_item' => esc_html__('Edit Branches','physio'),
            'new_item' => esc_html__('New Branches','physio'),
            'view' => esc_html__('View Branches','physio'),
            'view_item' => esc_html__('View Branches','physio'),
            'search_items' => esc_html__('Search Branches','physio'),
            'not_found' => esc_html__('No Branches Found','physio'),
            'not_found_in_trash' => esc_html__('No Branches Found in Trash','physio'),
            'parent' => esc_html__('Parent Branches','physio'),
        )
    ));
}

// Custom Career post

add_action('init', 'physioplus_career_register');

function physioplus_career_register() {
    register_post_type('career', array(
        'label' => esc_html__('Career','physio'),
        'description' => '',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'capability_type' => 'post',
        'map_meta_cap' => true,
        'hierarchical' => false,
        'rewrite' => array('slug' => 'career', 'with_front' => true),
        'query_var' => true,
        'menu_position' => '1200',        
        'menu_icon'   => 'dashicons-welcome-learn-more',
        'supports' => array('title','excerpt', 'editor','thumbnail', 'page-attributes'),
        'labels' => array(
            'name' => esc_html__('Career','physio'),
            'singular_name' => esc_html__('Career','physio'),
            'menu_name' => esc_html__('Career','physio'),
            'add_new' => esc_html__('Add Career','physio'),
            'add_new_item' => esc_html__('Add New Career','physio'),
            'edit' => esc_html__('Edit Career','physio'),
            'edit_item' => esc_html__('Edit Career','physio'),
            'new_item' => esc_html__('New Career','physio'),
            'view' => esc_html__('View Career','physio'),
            'view_item' => esc_html__('View Career','physio'),
            'search_items' => esc_html__('Search Career','physio'),
            'not_found' => esc_html__('No Career Found','physio'),
            'not_found_in_trash' => esc_html__('No Career Found in Trash','physio'),
            'parent' => esc_html__('Parent Career','physio'),
        )
    ));
}
?>