<?php
if ( !class_exists( 'Physioplus_Popular_Post' ) ) {

class Physioplus_Popular_Post extends WP_Widget {
	function __construct() {
		// Instantiate the parent object
		parent::__construct( false, 'Popular Post' );
	}
	function widget( $args, $instance ) {
		// Widget output
    	extract($args);
        $title = ($instance['title']) ? $instance['title'] : esc_html__('Popular Recent Posts', 'physioplus');
        $limit = ($instance['limit']) ? $instance['limit'] : 3;
    	$selected = ($instance['selected']) ? $instance['selected'] : '';
		echo wp_kses_post($before_widget);
		echo wp_kses_post($before_title);
		echo esc_html($title);
		echo wp_kses_post($after_title);
		
	  ?>
	<div class="popular-widget">
	  <?php
		  $featured_args = array(
		     'posts_per_page' => -1,
   		  );      
	      $featured_query = new WP_Query($featured_args);
      	  $k=0;	
		  if($featured_query->have_posts()) : 
		  
			while($featured_query->have_posts()) : $featured_query->the_post();         
			
			if ( has_post_thumbnail() ) { 

			if($k<$limit)
			{
			?>
				<div class="row recent-post-block">
                    <div class="col-md-5">
                    	<div class="recent-post-img zoom-pic">
                            <a href="<?php the_permalink(); ?>">                
								<?php
                                       the_post_thumbnail('full' , array( 'class' => 'img-responsive' ));     
                                ?>              
                            </a>
                        </div>
                    </div>
                    <div class="col-md-7 recent-post-desc">  
	                    <h3><a href="<?php the_permalink(); ?>" class="post-title"><?php the_title(); ?></a></h3>						 
    	                <div class="meta-style">
                        <?php                        
                        if(  $instance['selected'] ) {                           
                            physioplus_widget_date();  
                        } ?>
        	            </div>     
                    </div>
				</div>      
		  <?php 
	  		$k++;
	  		} 
		}?>
      <?php endwhile; 
	  endif; 
	  wp_reset_postdata(); ?>
    </div>
    <?php echo wp_kses_post($after_widget); ?>      
	<?php
	}
	function update( $new_instance, $old_instance ) {
		// Save widget options
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['limit'] = $new_instance['limit'];
		$instance['selected'] = $new_instance['selected'];
		return $instance;
	}
	function form( $instance ) {		
		// Output admin widget options form
      if(!isset($instance['title'])) $instance['title'] = esc_html__('Popular Posts', 'physioplus');
      if(!isset($instance['limit'])) $instance['limit'] = 3;  ?>

      <p>
     	<label for="<?php echo esc_html($this->get_field_id('title')); ?>"><?php esc_html_e('Title', 'physioplus') ?></label>
        <input  type="text" value="<?php echo esc_attr($instance['title']); ?>" name="<?php echo  esc_attr($this->get_field_name('title')); ?>" 
        id="<?php echo esc_attr($this->get_field_id('title')); ?>" class="widefat" />
      </p>
      <p>
      	<label for="<?php echo esc_attr($this->get_field_id('limit')); ?>"><?php esc_html_e('Limit Posts Number', 'physioplus') ?></label>
        <input  type="text" value="<?php echo esc_attr($instance['limit']); ?>" name="<?php echo esc_attr($this->get_field_name('limit')); ?>"
        id="<?php echo esc_attr($this->get_field_id('limit')); ?>" class="widefat" />
      </p>
      <p>
        <input class="checkbox" type="checkbox" <?php checked($instance['selected'], 'on'); ?> id="<?php echo esc_attr($this->get_field_id('selected')); ?>" 
        name="<?php echo esc_attr($this->get_field_name('selected')); ?>" /> 
        <label for="<?php echo esc_attr($this->get_field_id('selected')); ?>"><?php esc_html_e('Display post date? ', 'physioplus') ?></label>
      </p>
      <?php
	}
}

}


if ( class_exists( 'Physioplus_Popular_Post' ) ) {
	
	add_action( 'widgets_init', 'physioplus_custom_widget' );
	function physioplus_custom_widget() {
		register_widget( 'Physioplus_Popular_Post' );
	}
}
?>