<?php
if ( !class_exists( 'Physioplus_Service_Custom_Post' ) ) {
	
class Physioplus_Service_Custom_Post extends WP_Widget {
	function __construct() {
		// Instantiate the parent object
		parent::__construct( false, 'Service Post Display' );
	}
	function widget( $args, $instance ) {
		global $post;
		// Widget output
    	extract($args);
        $title = ($instance['title']) ? $instance['title'] : esc_html__('Service Custom Post', 'physioplus');
    	$selected = ($instance['selected']) ? $instance['selected'] : '';		
		echo wp_kses_post($before_widget);
		echo wp_kses_post($before_title);
		echo esc_html($title);
		echo wp_kses_post($after_title);


    $args = array( 'post_type' => 'service', 'posts_per_page' => -1,'orderby' => 'menu_order ID','order'   => 'ASC' );
    $service = new WP_Query( $args );
    
	$current_id=get_the_ID();
	if(count($service->posts)!=0)
	{
		
		if($instance['selected'])
		{	echo '<div class="service">';
			echo '<ul class="listnone chevron-circle-right">';
		}
		else{			
			echo '<div>';
			echo '<ul class="listnone">';		
		}
		while ( $service->have_posts() ) : $service->the_post();
		
		?>
			<li <?php if($current_id==$post->ID) echo 'class="active"'; ?>><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
		<?php
		endwhile; 		
		wp_reset_postdata();		
		
		echo '</ul>';
		echo '</div>';
	}
	echo wp_kses_post($after_widget);

	}
	function update( $new_instance, $old_instance ) {
		// Save widget options
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['selected'] = $new_instance['selected'];		
		return $instance;
	}
	function form( $instance ) {		
		// Output admin widget options form
      if(!isset($instance['title'])) $instance['title'] = esc_html__('Custom Post', 'physioplus');	  
	  ?>
      <p>
     	<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title', 'physioplus') ?></label>
        <input  type="text" value="<?php echo esc_attr($instance['title']); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" 
        id="<?php echo esc_attr($this->get_field_id('title')); ?>" class="widefat" />
      </p>
      <p>
        <input class="checkbox" type="checkbox" <?php checked($instance['selected'], 'on'); ?> id="<?php echo esc_attr($this->get_field_id('selected')); ?>" 
        name="<?php echo esc_attr($this->get_field_name('selected')); ?>" /> 
        <label for="<?php echo esc_attr($this->get_field_id('selected')); ?>"><?php esc_html_e('Display arrow? ', 'physioplus') ?></label>
      </p>      
      <?php
	}
}
}


if ( class_exists( 'Physioplus_Service_Custom_Post' ) ) {

	add_action( 'widgets_init', 'physioplus_service_custom_post' );
	function physioplus_service_custom_post() {
		register_widget( 'Physioplus_Service_Custom_Post' );
	}
}
?>